<?php
/**
 * The Prossociate Campaign.
 * Responsible for campaign crud
 */
class ProssociateCampaign {
    // Properties
    var $options;
    var $search_results; // we really should not use this
    var $id; // if ID is set, it was loaded from SQL, if $id is not set, it's a new campaign
    var $search; // the search object
    var $post_options;
    var $search_parameters;
    var $campaign_settings;
    var $name;
    var $last_run_time = 0;
    var $associated_posts;
    var $cron_mode;
    var $cron_page;
    var $cron_running = "no";
    var $cron_last_run_time = 0;
    
    /**
     * Construct
     * @param type $campaign_parameters
     */
    public function __construct( $campaign_parameters = null ) {
        $this->options = $campaign_parameters;
    }
    
    /**
     * Set the default $post_options property
     */
    public function defaults() {
        // Check if woocommerce is activated
        if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
            $this->post_options['post_type'] = 'product';
            $this->post_options['woocart'] = 'on';
        }
        
        $this->post_options['date_type'] = 'specific';
        $this->post_options['date'] = 'now';
        $this->post_options['download_images'] = 'on';
        $this->post_options['comment_status'] = 'open';
        $this->post_options['auto_category'] = 'yes';
    }
    
    /**
     * Search campaign function
     */
    public function search($asinLists = null) {
        // yuri - add sortby, browsenode parameter
        $this->search = new ProssociateSearch($this->options['keywords'], $this->options['searchindex'], $this->options['browsenode'], $this->options['sortby']);

        // Fix prices
        $minPrice = $this->search->makePrice($this->options['minprice']);
        $maxPrice = $this->search->makePrice($this->options['maxprice']);

        $this->search->set_advanced_options($minPrice, $maxPrice, $this->options['availability'], $this->options['condition'], $this->options['manufacturer'], $this->options['brand'], $this->options['merchantid'], $this->options['minpercentageoff']);

        // Check if we have asin lists
        if($asinLists) {
            $isLookUp = true;
            // Set asin lists
            $this->search->setAsinLists($this->options['dmasinlists']);
        } else {
            $isLookUp = false;
        }

        $this->search_results = $this->search->execute('Small,OfferSummary,Images,Variations,VariationOffers,Offers,OfferFull', $isLookUp); // we should not store this in search_results
    }
    
    /**
     * Post the result products from AmazonECS
     */
    public function post() {
        $poster = new ProssociatePoster($this);
        $poster->start_process();
        $this->last_run_time = Soflyy_time();
        $this->save();
    }
    
    /**
     * Save new campaign if $id property is given, else update existing campaign
     */
    public function save() {
        global $wpdb;
        
        // Check if $id propery isn't set
        if (!$this->id) 
        {
            // Insert new data
            $query = "INSERT INTO ".$wpdb->prefix.PROSSOCIATE_PREFIX."campaigns
	           ( name, options, search_results, post_options, search_parameters, campaign_settings, 
	           associated_posts, last_run_time, cron_mode, cron_page, cron_running, cron_last_run_time )
	           VALUES ( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s )";

            $prepared = $wpdb->prepare($query,
                    $this->name,
                    serialize($this->options),
                    serialize($this->search_results),
                    serialize($this->post_options),
                    serialize($this->search_parameters),
                    serialize($this->campaign_settings),
                    serialize($this->associated_posts),
                    $this->last_run_time,
                    $this->cron_mode,
                    $this->cron_page,
                    $this->cron_running,
                    $this->cron_last_run_time
            );
            
            $wpdb->query($prepared);
            // Set the $id propery as the new id generated by the db
            $this->id = $wpdb->insert_id;
        } 
        else 
        {
            // Update existing campaign
            $query = "UPDATE ".$wpdb->prefix.PROSSOCIATE_PREFIX."campaigns 
                        SET `name` = '%s',
                        `options` = '%s',
                        `search_results` = '%s',
                        `post_options` = '%s',
                        `search_parameters` = '%s',
                        `campaign_settings` = '%s',
                        `associated_posts` = '%s',
                        `last_run_time` = '%s',
                        `cron_mode` = '%s',
                        `cron_page` = '%s',
                        `cron_running` = '%s',
                        `cron_last_run_time` = '%s'
                        WHERE `id` = '%d'";
            $prepared = $wpdb->prepare($query,
            $this->name,
            serialize($this->options),
            serialize($this->search_results),
            serialize($this->post_options),
            serialize($this->search_parameters),
            serialize($this->campaign_settings),
            serialize($this->associated_posts),
            $this->last_run_time,
            $this->cron_mode,
            $this->cron_page,
            $this->cron_running,
            $this->cron_last_run_time,
            $this->id
            );
            $wpdb->query($prepared);
        }
    }
    
    /**
     * Load a campaign
     * @global object $wpdb
     * @param int $id
     */
    public function load( $id = null ) {
        global $wpdb;
        
        // Check if $id is null
        if ( !$id ) 
        {
            // Set the $id the same as $id property
            $id = $this->id;
        }
        
        // Select the campaign with the id = $this->id = $id
        $query = "SELECT * FROM " . $wpdb->prefix . PROSSOCIATE_PREFIX . "campaigns 
            WHERE `id` = '%d'";
        
        $result = $wpdb->get_row( $wpdb->prepare( $query, $id ) );
        
        // If no campaign was retrieved
        if( ! $result ) 
        {
            throw new Exception( "Unable to load campaign because no campaign exists in database for ID ". $id );
        }
        
        // Set the properties with the result
        $this->id = $result->id;
        $this->name = $result->name;
        $this->options = unserialize($result->options);
        $this->search_results = unserialize($result->search_results);
        $this->post_options = unserialize($result->post_options);
        $this->search_parameters = unserialize($result->search_parameters);
        $this->campaign_settings = unserialize($result->campaign_settings);
        $this->associated_posts = unserialize($result->associated_posts);
        $this->last_run_time = $result->last_run_time;
        $this->cron_mode = $result->cron_mode;
        $this->cron_page = $result->cron_page;
        $this->cron_running = $result->cron_running;
        $this->cron_last_run_time = $result->cron_last_run_time;

        // this might not be necessary
        $this->options['keywords'] = stripslashes($this->options['keywords']);
    }
    
    /**
     * Delete a campaign in the database
     */
    public function dbdelete( $id ) {
        global $wpdb;
        
        // Check if $id is give
        if ( !$id ) 
        {
            $id = $this->id;
        }
        
        $query = "DELETE FROM " . $wpdb->prefix . PROSSOCIATE_PREFIX . "campaigns 
            WHERE `id` = '%d'";
        
        $result = $wpdb->query( $wpdb->prepare( $query, $id ) );
    }

    /**
     * Delete the associated posts of a campaign
     * Should also delete the variations
     * @param int $id
     */
    public function delete_associated_posts( $id ) {
        // Load the given campaign
        $this->load( $id );
        
        if ($this->associated_posts) 
        {
            foreach ($this->associated_posts as $associated_post) 
            {
                wp_delete_post( $associated_post['id'], true );
            }
        }
    }

    /**
     * Associate a post in the campaign
     *
     * @param int $id
     * @param type $asin
     */
    public function associate_post( $id, $asin ) {
        $this->associated_posts[$id] = array("id" => $id, "asin" => $asin);
    }


    /**
     * Dissociates a post in the campaign
     * @param int $id
     */
    public function dissociate_post( $id ) {
        unset( $this->associated_posts[$id] );
    }

    /**
     * Get Associated posts of a campaign
     * @param int $campaignId
     */
    public function getAssociatedPosts($campaignId) {
        global $wpdb;

        // Select the campaign with the id = $this->id = $id
        $query = "SELECT associated_posts FROM " . $wpdb->prefix . PROSSOCIATE_PREFIX . "campaigns
            WHERE `id` = '%d'";

        $result = $wpdb->get_row( $wpdb->prepare( $query, $campaignId ) );

        return $result;
    }


}